IF OBJECT_ID('V_EST_SNGPC_ENTRADAS') IS NOT NULL
    BEGIN 
		DROP VIEW V_EST_SNGPC_ENTRADAS;
    END;
GO

CREATE VIEW V_EST_SNGPC_ENTRADAS
AS
WITH TREGINV
    AS ( SELECT
            F.CD_EMP
        , F.CD_FILIAL
        , ( SELECT MAX(DT) FROM (VALUES ( DT_INVT ), ( F.DT_INI_SISTEMA )) AS VALUE(DT)) AS DATA
    FROM
        PRC_FILIAL F WITH (NOLOCK)
        LEFT JOIN(SELECT
					B.CD_EMP
					, B.CD_FILIAL
					, MAX(B.DT_REINICIO) DT_INVT
				FROM
					EST_SNGPC_REINICIO_INVENTARIO B WITH (NOLOCK)
				GROUP BY
					B.CD_EMP
					, B.CD_FILIAL
				) I ON F.CD_EMP = I.CD_EMP
						AND F.CD_FILIAL = I.CD_FILIAL),
    ENVIO
    AS (SELECT
            B.CD_EMP
        , B.CD_FILIAL
        , MAX(DT_FINAL) AS FDATA
		FROM
			EST_SNGPC_RELATORIOS_ANVISA B
		WHERE B.ACEITO = 1
		GROUP BY
				B.CD_EMP
				, B.CD_FILIAL)
          
	SELECT
		IT.CD_FILIAL
		, IT.CD_NF
		, IT.CD_PROD
		, IT.DS_PROD
		, IT.CD_EMP
		, IT.DT_ENT
		, E.NR_NF
		, E.DT_EMI_NF
		, (CASE WHEN TRN.CD_EMP IS NULL THEN 'COMPRA'
				ELSE 'TRANSFERNCIA' END) AS TP_ENT                                                  
		, CASE WHEN O.DEST_ORIG = 1 THEN ( SELECT NM_FANT 
											FROM PG_FORN
											WHERE 
												PG_FORN.CD_EMP		= E.CD_EMP
												AND PG_FORN.CD_FORN = E.CD_FORN)
				WHEN O.DEST_ORIG = 2 THEN ( SELECT NM_FANT
											FROM
											PRC_FILIAL
											WHERE 
												PRC_FILIAL.CD_EMP		   = E.CD_EMP
												AND PRC_FILIAL.CD_FILIAL = E.CD_FORN )
				WHEN O.DEST_ORIG = 0 THEN( SELECT NM_FANT
											FROM RC_CLI
											WHERE 
												RC_CLI.CD_EMP = E.CD_EMP
												AND RC_CLI.CD_CLI = E.CD_FORN )

				ELSE 'SEM CLASSIFICAO DESTINATARIO' END AS NM_FORN 
		, E.CD_FORN
		, SUM(E.VLR_NF) AS VLR_NF
		, SUM(COALESCE(IT.QT_IT - CCL.QT_CANCEL, IT.QT_IT)) AS QT_IT
		, COALESCE( (SELECT SUM(BAIXAS.QT_LOTE)
						FROM EST_SNGPC_ENTRADA AS BAIXAS
						WHERE BAIXAS.CD_EMP = IT.CD_EMP
								AND BAIXAS.CD_FILIAL = IT.CD_FILIAL
								AND BAIXAS.CD_NF = IT.CD_NF
								AND BAIXAS.CD_PROD = IT.CD_PROD
						), 0) AS LANCADO
		, SUM(IT.QT_IT) AS QT_ORIGINAL
		, SUM(COALESCE(CCL.QT_CANCEL, 0)) AS CANCELADO
    FROM 
        EST_NF_ENT E
        INNER JOIN EST_NF_ENT_IT IT ON E.CD_EMP = IT.CD_EMP
                                        AND E.CD_FILIAL = IT.CD_FILIAL
                                        AND E.DT_ENT = IT.DT_ENT
                                        AND E.CD_NF = IT.CD_NF
        INNER JOIN GLB_MOV_OP O ON E.CD_NT_MOV = O.CD_MOV_OP
        INNER JOIN EST_PROD B ON IT.CD_EMP = B.CD_EMP
                                AND IT.CD_PROD = B.CD_PROD
        LEFT JOIN EST_NF_ENT_IT_EST_SNGPC_PENDENTE_CANCELADO CCL ON IT.CD_EMP = CCL.CD_EMP
                                                                    AND IT.CD_FILIAL = CCL.CD_FILIAL
                                                                    AND IT.CD_NF = CCL.CD_NF
                                                                    AND IT.CD_PROD = CCL.CD_PROD
        LEFT JOIN EST_NF_ENT_EST_NF_SAI_TRANSF AS TRN ON IT.CD_EMP = TRN.CD_EMP
                                                        AND IT.CD_FILIAL = TRN.CD_FIL_DEST
                                                        AND IT.CD_NF = TRN.CD_NF_ENT 
        INNER JOIN ENVIO TENVIO ON IT.CD_EMP = TENVIO.CD_EMP
                                    AND IT.CD_FILIAL = TENVIO.CD_FILIAL
                                    AND IT.DT_ENT > TENVIO.FDATA
        INNER JOIN TREGINV TMP ON IT.CD_EMP = TMP.CD_EMP
                                    AND IT.CD_FILIAL = TMP.CD_FILIAL
                                    AND IT.DT_ENT > TMP.DATA
    WHERE 
		B.CONTROLE_SNGPC = 1
        AND COALESCE(O.ATU_EST, 1) = 1
    GROUP BY
        IT.CD_FILIAL
        , IT.CD_NF
        , IT.CD_PROD
        , IT.DS_PROD
        , E.CD_EMP
        , IT.DT_ENT
        , E.NR_NF
        , E.DT_EMI_NF
        , TRN.CD_EMP
        , IT.CD_EMP
        , O.DEST_ORIG
        , E.CD_FORN;
GO